package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import com.ejie.p06b.datatype.logic.P06BInformeDEC;
import com.ejie.p06b.datatype.model.P06B46T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (26/01/2012)
 */
public class P06B46T00DAO {
	
	static private P06B46T00DAO instance = null;

	public static P06B46T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B46T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B46T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Obtiene la lista de Sucursales del Modelo 1 de la DEC, asociadas al expediente y ejercicio
    * @param ejer.
    * @param numExp          
    * @return Lista de objetos sucursales DEC Modelo 1
	 * @throws Exception
    */
	public ArrayList selectAllByEjerExp(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B46T00DAO-selectAllByEjerExp");
		ArrayList lista = new ArrayList();
		P06B46T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EJEREXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        while (lrst.next()){
	        	obj = new P06B46T00Datatype();

			    obj.setEjercicio(lrst.getString(P06BTablas.P06B_P06B46_EJERCICIO));
			    obj.setNumExp(lrst.getString(P06BTablas.P06B_P06B46_NUMEXP));
			    obj.setCod(lrst.getString(P06BTablas.P06B_P06B46_COD));
			    obj.setDomicilio(lrst.getString(P06BTablas.P06B_P06B46_DOMICILIO)==null?"":lrst.getString(P06BTablas.P06B_P06B46_DOMICILIO));
			    obj.setProvincia(lrst.getString(P06BTablas.P06B_P06B46_PROVINCIA)==null?"":lrst.getString(P06BTablas.P06B_P06B46_PROVINCIA));
			    obj.setNumAfec(lrst.getString(P06BTablas.P06B_P06B46_NUMAFEC)==null?"":lrst.getString(P06BTablas.P06B_P06B46_NUMAFEC));
			    obj.setNumNoAfec(lrst.getString(P06BTablas.P06B_P06B46_NUMNOAFEC)==null?"":lrst.getString(P06BTablas.P06B_P06B46_NUMNOAFEC));
			    obj.setPrimas(lrst.getString(P06BTablas.P06B_P06B46_PRIMAS)==null?"":lrst.getString(P06BTablas.P06B_P06B46_PRIMAS));
			    
	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B46T00DAO-selectAllByEjerExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}
	

	/**
    * Obtiene el nmero de oficinas por tipo de mediador para el informe de la DEC
    * @param ejerDEC.
    *            ejercicio de la DEC
    * @param objInformeDEC.
    *            objeto donde actualizar los datos obtenidos en la select
	* @throws Exception
    */
	public void selectNumOfisInformeDEC(String ejerDEC, P06BInformeDEC objInformeDEC, String tipoMed) throws Exception{
		P06BLog.send(2,this, "Inicio P06B46T00DAO-selectNumOfisInformeDEC");
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_NUM_OFI_INFORMEDEC;
        
        //Dependiendo del tipo hacer una select u otra. Corredores: F, J, RF, RJ. Vinculados: AF, AJ. Operadores banca: OV.
        if(P06BConstantes.P06B_CORR.equals(tipoMed)){
        	sql += " AND " + " (" + P06BTablas.P06B_P06B46_NUMEXP + " like '"+P06BConstantes.P06B_CORREDORES_TIPOPER_JURIDICA+"-%' or " + P06BTablas.P06B_P06B46_NUMEXP + " like '"+P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA+"-%' or " + P06BTablas.P06B_P06B46_NUMEXP + " like '"+P06BConstantes.P06B_REASEGUROS_JURIDICA+"-%' or " + P06BTablas.P06B_P06B46_NUMEXP + " like '"+P06BConstantes.P06B_REASEGUROS_FISICA+"-%')";
    	}else if(P06BConstantes.P06B_VINC.equals(tipoMed)){
    		sql += " AND " + " (" + P06BTablas.P06B_P06B46_NUMEXP + " like '"+P06BConstantes.P06B_AGENTEVINCULADO_FISICA+"-%' or " + P06BTablas.P06B_P06B46_NUMEXP + " like '"+P06BConstantes.P06B_AGENTEVINCULADO_JURIDICA+"-%')";
    	}else if(P06BConstantes.P06B_OBS.equals(tipoMed)){
    		sql += " AND " + " (" + P06BTablas.P06B_P06B46_NUMEXP + " like '"+P06BConstantes.P06B_OPERADORBANCA_VINCULADO+"-%' or " + P06BTablas.P06B_P06B46_NUMEXP + " like '"+P06BConstantes.P06B_OPERADORBANCA_EXCLUSIVO+"-%')";
    	}
        
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejerDEC.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	if(P06BConstantes.P06B_CORR.equals(tipoMed)){
	        		objInformeDEC.setNumOfiCorrM1(lrst.getInt("NUM_OFI_INFORMEDEC"));
	        	}else if(P06BConstantes.P06B_VINC.equals(tipoMed)){
	        		objInformeDEC.setNumOfiVincM1(lrst.getInt("NUM_OFI_INFORMEDEC"));
	        	}else if(P06BConstantes.P06B_OBS.equals(tipoMed)){
	        		objInformeDEC.setNumOfiObsM1(lrst.getInt("NUM_OFI_INFORMEDEC"));
	        	}		
	        }
	        P06BLog.send(2,this, "Fin P06B46T00DAO-selectNumOfisInformeDEC");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
	}


	private static String SELECTALL_BY_EJEREXP =
		"SELECT "
		+ P06BTablas.P06B_P06B46_EJERCICIO + ", "
		+ P06BTablas.P06B_P06B46_NUMEXP + ", "
		+ P06BTablas.P06B_P06B46_COD + ", "
		+ P06BTablas.P06B_P06B46_DOMICILIO + ", "
		+ P06BTablas.P06B_P06B46_PROVINCIA + ", "
		+ P06BTablas.P06B_P06B46_NUMAFEC + ", "
		+ P06BTablas.P06B_P06B46_NUMNOAFEC + ", "
		+ P06BTablas.P06B_P06B46_PRIMAS +
				
		" FROM " + P06BTablas.P06B_P06B46T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B46_EJERCICIO + "= ?" 
			+ " AND " + P06BTablas.P06B_P06B46_NUMEXP + "= ?"
		+" ORDER BY " + P06BTablas.P06B_P06B46_COD ;
	
	
	private static String SELECT_NUM_OFI_INFORMEDEC =
		"SELECT count("+ P06BTablas.P06B_P06B46_NUMEXP +") as NUM_OFI_INFORMEDEC" +	
		" FROM "+ P06BTablas.P06B_P06B46T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B46_EJERCICIO + " = ?";

}
